UBOOT_EXTRACT := u-boot/Makefile
UBOOT_BINS := u-boot/u-boot-rockchip.bin
UBOOT_XDEPS := $(_BL31) $(_ROCKCHIP_TPL)
CLEAN_FILES += u-boot uboot_fixes_timestamp
FULLCLEAN_FILES += u-boot.tar.gz

# Download and Extract
u-boot.tar.gz:
	$(MPROC) _download_u-boot.tar.gz
$(UBOOT_EXTRACT) &: u-boot.tar.gz
	$(MPROC) _check_u-boot.tar.gz
	$(MPROC) _extract_u-boot.tar.gz

# Configure and Build
$(UBOOT_BINS) &: \
  $(UBOOT_EXTRACT) uboot_fixes_timestamp $(UBOOT_XDEPS) $(BUILDER) u-boot.mk
	$(MAKE) -Cu-boot -f../Makefile _build_uboot
	touch -c $(UBOOT_BINS)
.PHONY: _build_uboot
_build_uboot:	# executed on u-boot/
	$(MPROC) evb-rk3568_defconfig
	../kconfig_update.sh BAUDRATE 115200
	../kconfig_update.sh PARTITION_TYPE_GUID y
	../kconfig_update.sh FAT_WRITE n
	../kconfig_update.sh BOOTDELAY 1
	../kconfig_update.sh USE_BOOTCOMMAND y
	../kconfig_update.sh -q BOOTCOMMAND \
		'load mmc 1:2 $${loadaddr} /boot/uboot.env; env import -t $${loadaddr} $${filesize}; bootd'
	../kconfig_update.sh -q DEFAULT_DEVICE_TREE rk3566-orangepi-cm4
	../kconfig_update.sh -q DEFAULT_FDT_FILE \
		rockchip/rk3566-orangepi-cm4.dtb
	../kconfig_update.sh -q OF_LIST rk3566-orangepi-cm4
	../kconfig_update.sh -q SPL_OF_LIST rk3566-orangepi-cm4
	$(MPROC)

# Fixes
uboot_fixes_timestamp: u-boot/arch/arm/dts/rk3566-orangepi-cm4.dts
	touch $@
u-boot/arch/arm/dts/rk3566-orangepi-cm4.dts: DTB=$(basename $(notdir $@)).dtb
u-boot/arch/arm/dts/rk3566-orangepi-cm4.dts: \
  $(UBOOT_EXTRACT) rk3566-orangepi-cm4.dts
	grep -q $(DTB) $(dir $@)/Makefile || \
		echo 'dtb-$$(CONFIG_ROCKCHIP_RK3568) += $(DTB)' \
		>> $(dir $@)/Makefile
	cp $(dir $@)/rk3568-evb-u-boot.dtsi $(basename $@)-u-boot.dtsi
	cp $(notdir $@) $@
