LINUX_EXTRACT := linux/Makefile
LINUX_BINS := \
	linux/arch/arm64/boot/Image \
	linux/arch/arm64/boot/dts/rockchip/rk3566-orangepi-cm4.dtb
CLEAN_FILES += linux linux_fixes_timestamp
FULLCLEAN_FILES += linux.tar.xz

# Download and Extract
linux.tar.xz:
	$(MPROC) _download_linux.tar.xz
$(LINUX_EXTRACT) &: linux.tar.xz
	$(MPROC) _check_linux.tar.xz
	$(MPROC) _extract_linux.tar.xz

# Configure and Build
$(LINUX_BINS) &: $(LINUX_EXTRACT) linux_fixes_timestamp $(BUILDER) linux.mk
	$(MAKE) -Clinux -f../Makefile _build_linux
	touch -c $(LINUX_BINS)
.PHONY: _build_linux
_build_linux:	# executed on linux/
	$(MPROC) defconfig
	$(MPROC) mod2noconfig
	../kconfig_update.sh -a arch/arm64/Kconfig.platforms n ARCH_ROCKCHIP
	../kconfig_update.sh CHROME_PLATFORMS n
	../kconfig_update.sh SURFACE_PLATFORMS n
	../kconfig_update.sh ACPI n
	../kconfig_update.sh PCI n
	../kconfig_update.sh FPGA n
	../kconfig_update.sh HIBERNATION n
	../kconfig_update.sh AUDIT n
	../kconfig_update.sh VIRTUALIZATION n n
	../kconfig_update.sh XEN n
	../kconfig_update.sh VIRTIO n
	../kconfig_update.sh PARAVIRT n
	../kconfig_update.sh ROCKCHIP_THERMAL y
	../kconfig_update.sh STMMAC_ETH y
	../kconfig_update.sh STMMAC_PLATFORM y
	../kconfig_update.sh DWMAC_ROCKCHIP y
	../kconfig_update.sh MOTORCOMM_PHY y
	../kconfig_update.sh PHY_ROCKCHIP_NANENG_COMBO_PHY y
	../kconfig_update.sh LEDS_TRIGGER_ONESHOT y
	../kconfig_update.sh LEDS_TRIGGER_TRANSIENT y
	../kconfig_update.sh LEDS_TRIGGER_NETDEV y
	../kconfig_update.sh LEDS_TRIGGER_PATTERN y
	../kconfig_update.sh LEDS_TRIGGER_TTY y
	../kconfig_update.sh USB_USBNET m
	../kconfig_update.sh USB_NET_AX88179_178A m
	$(MPROC)

# Fixes
linux_fixes_timestamp: \
  linux/arch/arm64/boot/dts/rockchip/rk3566-orangepi-cm4.dts
	touch $@

linux/arch/arm64/boot/dts/rockchip/rk3566-orangepi-cm4.dts: \
  DTB=$(basename $(notdir $@)).dtb
linux/arch/arm64/boot/dts/rockchip/rk3566-orangepi-cm4.dts: \
  $(LINUX_EXTRACT) rk3566-orangepi-cm4.dts
	grep -q $(DTB) $(dir $@)/Makefile || \
		echo 'dtb-$$(CONFIG_ARCH_ROCKCHIP) += $(DTB)' \
		>> $(dir $@)/Makefile
	cp $(notdir $@) $@
