#!/bin/sh

OPTS="-o qac:"
getopt -T >/dev/null 2>&1
if [ $? -eq 4 ]; then
    eval "set -- $(getopt $OPTS -- "$@")"
else
    set -- $(getopt $OPTS -- "$@")
fi

set -e

MODE=normal
QUOTE=
CONFIG=.config
while [ $# -gt 0 -a "x$1" != "x--" ]; do
    case "$1" in
    -q)
        QUOTE='"'
        shift;;
    -a)
        MODE=all
        shift;;
    -c)
        CONFIG="$2"
        shift 2;;
    *)
        echo "unknown option: $1"
        exit 1;
    esac
done
[ "x$1" = "x--" ] && shift

confupdate() {
    grep -v -- '^\(# \)\{,1\}'"CONFIG_$1[= ]" "$CONFIG" > "$CONFIG.$$"
    echo "CONFIG_$1=$QUOTE$2$QUOTE" >> "$CONFIG.$$"
    mv -- "$CONFIG.$$" "$CONFIG"
}

list_confs() {
    cat "$1" | grep '^\(menu\|\)config' | sed 's/^[a-z]* *//; s/ .*//'
}

case "$MODE" in
normal)
    while [ $# -ge 2 ]; do
        confupdate "$1" "$2"
        shift 2
    done
    ;;
all)
    FILE="$1"
    VALUE="$2"
    shift 2
    list_confs "$FILE" | while read c; do
        if (while [ $# -gt 0 ]; do
            [ "x$1" = "x$c" ] && exit 1
            shift
        done; exit 0); then
            confupdate "$c" "$VALUE"
        fi
    done
    ;;
esac
