BUSYBOX_EXTRACT := busybox/Makefile
BUSYBOX_BINS := busybox/busybox
CLEAN_FILES += busybox
FULLCLEAN_FILES += busybox.tar.bz2

# Download and Extract
busybox.tar.bz2:
	$(MPROC) _download_busybox.tar.bz2
$(BUSYBOX_EXTRACT) &: busybox.tar.bz2
	$(MPROC) _check_busybox.tar.bz2
	$(MPROC) _extract_busybox.tar.bz2

# Configure and Build
$(BUSYBOX_BINS) &: \
  $(BUSYBOX_EXTRACT) $(BUILDER) busybox.mk
	$(MAKE) -Cbusybox -f../Makefile _build_busybox
	touch -c $(BUSYBOX_BINS)
.PHONY: _build_busybox
_build_busybox:	# executed on busybox/
	$(MPROC) allnoconfig
	# resuired for bootstrap_s0.
	../kconfig_update.sh STATIC y
	../kconfig_update.sh ASH y
	../kconfig_update.sh ASH_OPTIMIZE_FOR_SIZE y
	../kconfig_update.sh SH_IS_ASH y
	../kconfig_update.sh LN y
	../kconfig_update.sh USLEEP y
	../kconfig_update.sh MKDIR y
	../kconfig_update.sh MOUNT y
	../kconfig_update.sh FEATURE_MOUNT_FLAGS y
	../kconfig_update.sh MKNOD y
	../kconfig_update.sh FEATURE_SH_MATH y
	../kconfig_update.sh TEST y
	../kconfig_update.sh TEST1 y
	../kconfig_update.sh ECHO y
	../kconfig_update.sh FEATURE_FANCY_ECHO y
	../kconfig_update.sh SED y
	../kconfig_update.sh XZ y
	../kconfig_update.sh TAR y
	../kconfig_update.sh GREP y
	../kconfig_update.sh UMOUNT y
	../kconfig_update.sh CP y
	../kconfig_update.sh SWITCH_ROOT y
	# not needed, but for diagnose.
	../kconfig_update.sh LS y
	../kconfig_update.sh MV y
	../kconfig_update.sh RM y
	../kconfig_update.sh CAT y
	../kconfig_update.sh HEAD y
	../kconfig_update.sh TAIL y
	../kconfig_update.sh MORE y
	../kconfig_update.sh DF y
	../kconfig_update.sh WC y
	../kconfig_update.sh MD5SUM y
	../kconfig_update.sh OD y
	../kconfig_update.sh HD y
	../kconfig_update.sh CHROOT y
	../kconfig_update.sh FEATURE_EDITING y
	../kconfig_update.sh FEATURE_EDITING_MAX_LEN 1024
	../kconfig_update.sh FEATURE_EDITING_HISTORY 255
	../kconfig_update.sh FEATURE_TAB_COMPLETION y
	../kconfig_update.sh FEATURE_FANCY_HEAD y
	../kconfig_update.sh FEATURE_FANCY_TAIL y
	../kconfig_update.sh SHOW_USAGE y
	$(MPROC)
