#!/bin/sh

. /bootstrap.conf

echo "Running debootstrap second stage..."
cp -p /var/lib/dpkg/status /tmp/dpkg_status
# It is not extracted by stage-1. Manually extract it.
dpkg -x /var/cache/apt/archives/libc-bin_*.deb /tmp/extroot
(cd /tmp/extroot; find -type d) | while read d; do
    mkdir -p "$d"
done
(cd /tmp/extroot; find -type l; find -type f) | while read f; do
    mv /tmp/extroot/"$f" "$f"
done
rm -r /tmp/extroot
# Writeback old dpkg/status. It is required by debootstrap stage-2.
mv /tmp/dpkg_status /var/lib/dpkg/status

DPKG_FORCE=unsafe-io /debootstrap/debootstrap --second-stage
[ -e /proc/self ] || mount -t proc none /proc
[ -e /dev/null ] || mknod /dev/null c 1 3

echo "Write system configs..."
if dpkg -s sudo > /dev/null; then
    SUDO_EXISTS=y
else
    SUDO_EXISTS=n
fi

if [ -z "$ROOTPASSWD" -a -n "$USERNAME" -a $SUDO_EXISTS = y ]; then
    usermod -p\* root
else
    usermod -p "$ROOTPASSWD" root
fi
if [ -n "$USERNAME" ]; then
    if [ -z "$USERGROUPS" ]; then
        USERGROUPS=adm,dialout,plugdev,netdev,audio,video,render
        if [ $SUDO_EXISTS = y ]; then
            USERGROUPS="$USERGROUPS,sudo"
        fi
    fi
    useradd -m -p "$USERPASSWD" -G $USERGROUPS -s "$USERSHELL" "$USERNAME"
fi

if [ -n "$LOCALTIME" ]; then
    rm /etc/localtime
    ln -s /usr/share/zoneinfo/"$LOCALTIME" /etc/localtime
fi

echo "${HOSTNAME:=pi}" > /etc/hostname
echo "127.0.1.1 ${HOSTNAME}" >> /etc/hosts

echo /dev/$ROOTPARTDEV / ext4 $(
    echo errors=remount-ro $ROOTMOUNT_OPT $ROOTMOUNT_OPT_FSTAB | tr " " ,
    ) 0 1 >> /etc/fstab

if [ -n "${IPADDR}" ]; then
    echo "allow-hotplug end0" >> /etc/network/interfaces
    echo "iface end0 inet static" >> /etc/network/interfaces
    echo "	address ${IPADDR}" >> /etc/network/interfaces
    [ -n "${GATEWAY}" ] \
        && echo "	gateway ${GATEWAY}" >> /etc/network/interfaces
fi

(
    sync
    mv /boot/uboot.env.final /boot/uboot.env
    sync
    rm /boot/initrd.bootstrap.gz
    rm /bootstrap.tar.xz
    rm /bootstrap.conf
    rm /bootstrap_s1.sh
) &

echo "Exec init..."
INIT="$(cat /proc/cmdline | tr ' ' '\n' | grep ^init= | sed 's/^[^=]*=//')"
exec ${INIT:-/sbin/init}
