#!/bin/busybox sh

(set -e
. /bootstrap.conf

# prepare commands
for b in \
    sh ln usleep mkdir mount mknod test [ echo sed xz tar grep umount cp \
    switch_root ls mv rm cat head tail more df wc md5sum od hd chroot
do
    busybox ln -s busybox /bin/$b
done

# execution environ
mkdir /proc; mount -t proc none /proc
mkdir /sys; mount -t sysfs none /sys

mknod /dev/$ROOTDEV b $ROOTDEV_MAJOR $ROOTDEV_MINOR
mknod /dev/$ROOTPARTDEV b $ROOTDEV_MAJOR $((ROOTDEV_MINOR + ROOTPART))

echo "Waiting for root device..."
while [ ! -e /sys/block/$ROOTDEV/$ROOTPARTDEV ]; do usleep 10000; done

echo "Mounting root device..."
mkdir /proot
mount -oro,$ROOTMOUNT_OPT /dev/$ROOTPARTDEV /proot

echo "Extracting additional executables..."
WANTED=$( echo -n ^; (
    for lib in libe2p libext2fs libcom_err libc libblkid libuuid \
        libreadline libtinfo libsmartcols libfdisk
    do
        echo -n './\(usr/\|\)lib/aarch64-linux-gnu/'"$lib.so."'\|^'
    done
    for bin in sfdisk resize2fs tune2fs; do
        echo -n './\(usr/\|\)\(s\|\)bin/'"$bin"'\|^'
    done
    echo -n './\(usr/\|\)lib/[^!]*ld-linux-aarch64.so.'
) | sed 's/\./\\./g')
xz -dc proot/bootstrap.tar.xz | tar -xvf - $(
    xz -dc proot/bootstrap.tar.xz | tar -tf - | grep "$WANTED")
ln -s usr/lib lib

echo "Expanding partition and randomize UUID..."
umount /proot
sfdisk -d /dev/$ROOTDEV \
    | sed '
            /^last-lba:/ d
            /^label-uuid:/ d
            /^first-lba:/ b l
            /^[^:]*'"$ROOTPARTDEV"' :/ b r
            p;d
            :l s/:.*/: 64/; p;d
            :r s/size[^,]*,//; p;d
        ' \
    | sfdisk /dev/$ROOTDEV
resize2fs /dev/$ROOTPARTDEV
tune2fs -Urandom /dev/$ROOTPARTDEV
mount -o$ROOTMOUNT_OPT /dev/$ROOTPARTDEV /proot

echo "Unpacking bootstrap..."
xz -dc proot/bootstrap.tar.xz | tar -xf - -C proot
cp bootstrap_s1.sh /proot
cp bootstrap.conf /proot
) || {
    echo "Falling back to busybox shell..."
    exec sh
}

echo "Do switch_root..."
: > /init           # switch_root in busybox requires it
exec switch_root /proot /bootstrap_s1.sh
