DEBIAN_SUITE := bookworm
DEBIAN_INCLUDE := e2fsprogs fdisk dbus dbus-user-session systemd-timesyncd
DEBIAN_INCLUDE += sudo vim bash-completion

CLEAN_FILES += bootstrap.tar.xz bootstrap.dir bootstrap.dir2
FULLCLEAN_FILES += debcache

bootstrap.tar.xz: $(BUILDER) bootstrap.mk
	$(RPROC) _bootstrap_tar
.PHONY: _bootstrap_tar
_bootstrap_tar:
	rm -rf bootstrap.dir
	mkdir bootstrap.dir
	rm -rf bootstrap.dir2
	mkdir bootstrap.dir2
	mkdir -p debcache
	/usr/sbin/debootstrap \
		--cache-dir="$$(pwd)/debcache" --arch=arm64 --foreign \
		--include=$(shell echo $(DEBIAN_INCLUDE) | tr ' ' ,) \
		$(DEBIAN_SUITE) bootstrap.dir
	-for d in fdisk libfdisk1 libreadline8 readline-common; do \
		dpkg -x bootstrap.dir/var/cache/apt/archives/"$$d"_*.deb \
			bootstrap.dir2; \
	done
	(cd bootstrap.dir2; find -type d) \
		| while read d; do mkdir -p bootstrap.dir/$$d; done
	(cd bootstrap.dir2; find -type l; find -type f) \
		| while read f; do mv bootstrap.dir2/$$f bootstrap.dir/$$f; done
	cd bootstrap.dir; tar -Jcf ../bootstrap.tar.xz .
